/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.src;

import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.world.World;

public class Explosion {
    public static void circleExplosion(World world, float explosionDamage, int x, int y, int z) {
        boolean removed = world.setBlock(x, y, z, 0);
        if (removed) {
            int radius = (int)(explosionDamage / 2.0f);
            int dx = -radius;
            while (dx <= radius) {
                int dy = -radius;
                while (dy <= radius) {
                    int dz = -radius;
                    while (dz <= radius) {
                        boolean destroyed;
                        Block targetBlock;
                        float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                        if (!(distance <= (float)radius) || (targetBlock = Blocks.blocks[world.getBlock(x + dx, y + dy, z + dz)]).isExplosionResistant() || targetBlock == null || (destroyed = world.setBlock(x + dx, y + dy, z + dz, 0))) {
                            // empty if block
                        }
                        ++dz;
                    }
                    ++dy;
                }
                ++dx;
            }
        }
    }

    public static void raycastExplosion(World world, float explosionDamage, float x, float y, float z) {
        int rays = 32 * (int)explosionDamage;
        float radius = explosionDamage / 0.5f;
        float step = 0.3f;
        int i2 = 0;
        while (i2 < rays) {
            float theta = (float)(Math.random() * Math.PI * 2.0);
            float phi = (float)(Math.random() * Math.PI);
            float dirX = (float)(Math.sin(phi) * Math.cos(theta));
            float dirY = (float)Math.cos(phi);
            float dirZ = (float)(Math.sin(phi) * Math.sin(theta));
            float power = radius;
            float px = x;
            float py = y;
            float pz = z;
            while (power > 0.0f) {
                int bz;
                int by;
                int bx = (int)Math.floor(px += dirX * step);
                int blockId = world.getBlock(bx, by = (int)Math.floor(py += dirY * step), bz = (int)Math.floor(pz += dirZ * step));
                Block block = Blocks.blocks[blockId];
                if (block != null) {
                    if (block.isExplosionResistant()) break;
                    world.setBlock(bx, by, bz, 0);
                    power -= 1.5f;
                }
                power -= step;
            }
            ++i2;
        }
    }
}

